 ; Ŀ
 ;   Blurb - block replacer for use in script files.                       
 ;   Copyright 1994, 1997 by Rocket Software                               
 ;   Named for the speed at which it operates, not the state of your       
 ;   vision after eight hours in front of a monitor.                       
 ; 

 ; Ŀ
 ;   Blurt - error handler.                                                
 ; 
 (DEFUN BLURT (shk / pos entt enam sublst vall)
  (setq *error* esav)
  (setvar "attreq" atrq)
  (setvar "limcheck" limch)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Blurt end.                                                            
 ; 

 ; Ŀ
 ;   Blurb - the bullet.                                                   
 ; 
 (DEFUN C:BLURB (/ old typp ss new isnew blcfil insp isdef usedef how esav enam
                       entt scla pa rota xsc ysc zsc layy main sub tagg cc num)
  (setvar "cmdecho" 0)
  (command "undo" "M")
  (setq esav *error*)                    ; save the previous error handler
  (setq *error* blurt)                   ; and install the new one
  (setq limch (getvar "limcheck"))
  (setvar "limcheck" 0)
  (setq atrq (getvar "attreq"))
  (setvar "attreq" 0)
 ; Ŀ
 ;   Set the existing and replacement block names.                         
 ; 
  (setq old "Snow-tb")
  (setq new "Snow-tb")
 ; Ŀ
 ;   At this point if ss exists then we have two block names, both are     
 ;   present and there are some of the original ones ready to replace.     
 ; 
  (if (setq ss (ssget "X" (list (cons 2 old))))
     (progn
 ; Ŀ
 ;   Decide how to reapply attribute values - by Attribute or in Order.    
 ; 
          (setq how "Attribute")
 ; Ŀ
 ;   Ask at what scale the new blocks should be inserted (Null = current.) 
 ; 
          (setq scla ())
 ; Ŀ
 ;   The selection set processor loop.                                     
 ; 
          (setq num 0)
          (while (setq esav (setq enam (ssname ss 0)))
                 (grtext -2 (itoa (setq num (1+ num))))
                 (ssdel esav ss)
                 (setq entt (entget enam))
 ; Ŀ
 ;   Find the block insertion, X, Y, and Z scales, rotation and layer.     
 ; 
                 (setq pa (cdr (assoc 10 entt)))
                 (setq rota (cdr (assoc 50 entt)))
                 (if rota
                    (setq rota (/ (* 180 rota) pi))
                    (setq rota 0))
                 (if scla
                    (progn
                         (setq xsc scla)
                         (setq ysc scla)
                         (setq zsc scla))
                    (progn
                         (setq xsc (cdr (assoc 41 entt)))
                         (if (null xsc) (setq xsc 1))
                         (setq ysc (cdr (assoc 42 entt)))
                         (if (null ysc) (setq ysc 1))
                         (setq zsc (cdr (assoc 43 entt)))
                         (if (null zsc) (setq zsc 1))))
                 (setq layy (assoc 8 entt))
 ; Ŀ
 ;   Step through the block and get attribute tags and values.             
 ;   (if there are attributes - the 66 sublist is present.)                
 ; 
                 (setq main ())
                 (if (assoc 66 (entget enam))
                     (while (and (setq enam (entnext enam))
                                 (/= (cdr (assoc 0 (setq entt (entget enam))))
                                                                     "SEQEND"))
                            (setq sub (list (assoc 2 entt) (assoc 1 entt)))
                            (setq main (append main (list sub)))))
 ; Ŀ
 ;   Now erase the old new block and insert the new one.                   
 ; 
                 (entdel esav)
                 (command "insert" new pa "xyz" xsc ysc zsc rota)
                 (setq esav (setq enam (entlast)))
 ; Ŀ
 ;   And reapply the attribute values depending on the value of How.       
 ; 
                 (cond ((or (= how "Attribute") (= how "Tag"))
                        (while (and (setq enam (entnext enam))
                                    (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                               (setq tagg (assoc 2 entt))
                               (if (setq cc (assoc tagg main))
                                   (entmod (subst (cadr cc)
                                                  (assoc 1 entt) entt))
                                   (if (null usedef)
                                       (entmod (subst (cons 1 "")
                                                      (assoc 1 entt) entt))))))
                       ((= how "Order")
                        (while (and (setq enam (entnext enam))
                                    (/= (cdr (assoc 0 (setq entt
                                                    (entget enam)))) "SEQEND"))
                               (setq cc (cadar main))
                               (setq main (cdr main))
                               (if cc
                                  (entmod (subst cc (assoc 1 entt) entt))
                                  (if (null usedef)
                                      (entmod (subst (cons 1 "")
                                                     (assoc 1 entt) entt)))))))
 ; Ŀ
 ;   Put the block on the correct layer.                                   
 ; 
                 (setq entt (entget esav))
                 (entmod (subst layy (assoc 8 entt) entt))
                 )))               ; while end, ifend, progend
 ; Ŀ
 ;   Report.                                                               
 ; 
  (if num (write-line (strcat (itoa num) " block"
                              (if (= num 1) "" "s") " replaced.")))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (setvar "attreq" atrq)
  (setvar "limcheck" limch)
  (setq *error* esav)        ; restore the original error handler
 (princ))